import { invalid, error, redirect } from '@sveltejs/kit';

export const actions = {
	default: async ({ fetch, request, url }) => {
		const data = await request.formData();
		const name = data.get('name');
		const message = data.get('message');

		if (!name) {
			return invalid(400, { name, message, error: 'name.missing' });
		}

		if (!message) {
			return invalid(400, { name, message, error: 'message.missing' });
		}

		if (message.length > 100) {
			return invalid(400, { name, message, error: 'message.invalid' });
		}

		const response = await fetch('http://localhost:3000/tweets', {
			method: 'POST',
			headers: {
				'Content-Type': 'application/json'
			},
			body: JSON.stringify({ id: crypto.randomUUID(), name, message })
		});

		if (!response.ok) {
			throw error(response.status, response.statusText);
		}

		if (url.searchParams.has('redirectTo')) {
			throw redirect(303, url.searchParams.get('redirectTo'));
		}

		return {
			success: true
		};
	}
};
